/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.math.Point;
import icyllis.modernui.view.DragData;
import icyllis.modernui.view.DragEvent;
import icyllis.modernui.view.InputEvent;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.UIManager;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewParent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ViewRootImpl
implements ViewParent {
    private final UIManager master;
    private boolean hasDragOperation;
    private View mView;

    public ViewRootImpl(UIManager manager) {
        this.master = manager;
    }

    void setView(@Nonnull View view) {
        if (this.mView == null) {
            this.mView = view;
            view.assignParent(this);
            view.dispatchAttachedToWindow(this);
        }
    }

    boolean startDragAndDrop(@Nonnull View view, @Nullable DragData data, @Nullable View.DragShadow shadow, int flags) {
        if (this.master.dragEvent != null) {
            ModernUI.LOGGER.error(View.MARKER, "startDragAndDrop failed by another ongoing operation");
            return false;
        }
        Point center = new Point();
        if (shadow == null) {
            shadow = new View.DragShadow(view);
            if (view.isHovered()) {
                center.x = (int)this.master.getViewMouseX(view);
                center.y = (int)this.master.getViewMouseY(view);
            } else {
                shadow.onProvideShadowCenter(center);
            }
        } else {
            shadow.onProvideShadowCenter(center);
        }
        this.master.dragEvent = new DragEvent(data);
        this.master.dragShadow = shadow;
        this.master.dragShadowCenter = center;
        this.hasDragOperation = true;
        this.master.performDrag(1);
        return true;
    }

    void performLayout(int widthSpec, int heightSpec) {
        if (this.mView == null) {
            return;
        }
        this.mView.measure(widthSpec, heightSpec);
        this.mView.layout(0, 0, this.mView.getMeasuredWidth(), this.mView.getMeasuredHeight());
    }

    void onDraw(Canvas canvas) {
        if (this.mView != null) {
            this.mView.draw(canvas);
        }
    }

    boolean onInputEvent(InputEvent event) {
        if (this.mView != null) {
            if (event instanceof KeyEvent) {
                return this.processKeyEvent((KeyEvent)event);
            }
            return this.processPointerEvent((MotionEvent)event);
        }
        return false;
    }

    private boolean processKeyEvent(KeyEvent event) {
        return false;
    }

    private boolean processPointerEvent(MotionEvent event) {
        return this.mView.dispatchPointerEvent(event);
    }

    void performDragEvent(DragEvent event) {
        if (this.hasDragOperation) {
            // empty if block
        }
    }

    void tick(int ticks) {
        if (this.mView != null) {
            this.mView.tick(ticks);
        }
    }

    @Override
    @Nullable
    public ViewParent getParent() {
        return null;
    }

    @Override
    public void requestLayout() {
        this.master.mLayoutRequested = true;
    }

    @Override
    public float getScrollX() {
        return 0.0f;
    }

    @Override
    public float getScrollY() {
        return 0.0f;
    }

    @Override
    public void childDrawableStateChanged(View child) {
    }
}

